package furny.ga.rules;

import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import ga.core.validation.GAContext;
import ga.core.validation.IValidationRule;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This is a {@link IValidationRule} implementation that prevents from
 * furnitures intersecting each other.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class FurnitureIntersectionRule implements
    IValidationRule<FurnLayoutIndividual> {

  // the logger for this class
  private static final Logger LOGGER = Logger
      .getLogger(FurnitureIntersectionRule.class.getName());

  @Override
  public float matchingDegree(final FurnLayoutIndividual individual,
      final GAContext context) {
    final FurnEntryList list1 = new FurnEntryList(individual.getFurnitures());
    final FurnEntryList list2 = new FurnEntryList(list1);

    while (list1.size() > 0) {
      final FurnEntry entry1 = list1.remove(0);

      for (final FurnEntry entry2 : list2) {
        if (entry1 != entry2
            && entry1
                .getBounds()
                .getBoundingBox()
                .getAsAWTRectangle2D()
                .intersects(
                    entry2.getBounds().getBoundingBox().getAsAWTRectangle2D())) {

          if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(individual.getId() + ":  " + entry1 + " intersects "
                + entry2);
          }
          return 0;
        } else {
          if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(individual.getId() + ":  " + entry1
                + " intersects not " + entry2);
          }
        }
      }
    }

    return 1;
  }

  @Override
  public IValidationRule.Type getType() {
    return Type.MANDATORY;
  }
}
